'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) 2004  Microsoft Corporation.  All rights reserved.
'***********************************************************************

' Provisioning Requests
' Create an Organizational Unit and set the Permissions
Function CreateOrganization(xi_OrgName, xi_PolicyType, xi_Description, xi_strContPath)

    On Error Resume Next
    
	'DIM VARIABLES
    Dim objXml
    Dim objOrg

    Dim strXmlFile
    Dim strXMLResponse
    Dim AdsPath

    'LOAD THE XML OBJECT
    Set objXML = CreateObject("MSXML2.DOMDocument")
    
	'LOAD XML TEMPLATE
	strXmlFile = strXMLPath & "\AD\" & "CreateOrganization.xml"
	objXml.Load (strXmlFile)
    
	'SET THE ORG NAME
    Set objOrg = objXml.selectSingleNode("/request/data/name")
    objOrg.Text = CStr(xi_OrgName)

	'SET THE POLICY TYPE
    Set objOrg = objXml.selectSingleNode("//*/data/policyName")
    objOrg.Text = CStr(xi_PolicyType)
	
	'SET THE CONTAINER
    Set objOrg = objXml.selectSingleNode("//*/data/container")
    objOrg.Text = xi_strContPath

	'SET THE DESCRIPTION
    Set objOrg = objXml.selectSingleNode("//*/data/description")
    objOrg.Text = CStr(xi_Description)

	'SET THE PREFERRED DOMAIN CONTROLLER
    Set objOrg = objXml.selectSingleNode("//*/data/preferredDomainController")
    objOrg.Text = CStr(prefDC)

	'SUBMIT THE REQUEST
	strXMLResponse = SubmitMPFRequest(objXML.xml, "Managed Active Directory", _
						"CreateOrganization")		

    'CHECK FOR ERROR
    If Err.number <> 0 Then
    	Call ProcessMPFError
		Exit Function
	Else
		' Do nothing
    End If

	'GET LDAP PATH FROM RESPONSE
	objXml.LoadXML(strXMLResponse)

	Set objOrg = objXml.selectSingleNode("//*/data/org")
	
	CreateOrganization = objOrg.getAttribute("path")
    
    'Kill Ojects
    Set objOrg = Nothing
    Set objXml = Nothing

End Function

Function CreateUser(xi_strUPN, xi_strDisplayName, xi_strFName, xi_strLName, xi_strPolicy, xi_strContainer)
    On Error Resume Next
    
	'DIM VARIABLES
    Dim objXml
    Dim objOrg

    Dim strXmlFile
    Dim strXMLResponse
    Dim AdsPath

    'LOAD THE XML OBJECT
    Set objXML = CreateObject("MSXML2.DOMDocument")
    
	'LOAD XML TEMPLATE    
    strXmlFile = strXMLPath & "\AD\" & "CreateUser.xml"
    objXml.Load (strXmlFile)
    
	'SET THE UPN
    Set objOrg = objXml.selectSingleNode("//*/data/userPrincipalName")
    objOrg.Text = CStr(xi_strUPN)

	'SET THE POLICY TYPE
    Set objOrg = objXml.selectSingleNode("//*/data/policyName")
    objOrg.Text = xi_strPolicy
	
	'SET THE CONTAINER
    Set objOrg = objXml.selectSingleNode("//*/data/container")
    objOrg.Text = xi_strContainer

	'SET THE DISPLAY NAME
    Set objOrg = objXml.selectSingleNode("//*/data/displayName")
    If Len(xi_strDisplayName) > 0 then
		objOrg.Text = xi_strDisplayName
	Else
	    objOrg.Text = xi_strLName & ", " & xi_strFName
	End If

	'SET THE GIVEN NAME
    Set objOrg = objXml.selectSingleNode("//*/data/givenName")
    objOrg.Text = xi_strFName

	'SET THE SN
    Set objOrg = objXml.selectSingleNode("//*/data/sn")
    objOrg.Text = xi_strLName

	'SET THE PREFERRED DOMAIN CONTROLLER
    Set objOrg = objXml.selectSingleNode("//*/data/preferredDomainController")
    objOrg.Text = CStr(prefDC)

	'SUBMIT THE REQUEST
    strXMLResponse = SubmitMPFRequest(objXml.Xml, "Managed Active Directory", _
							"CreateUser")
    'CHECK FOR ERROR
    If Err.number <> 0 Then
		'DEBUG CODE
		If blnMainDebug Then
			Call WriteRecord(DEBUGFILEPATH, Err.Description, "CreateUser-ERR")
		End If
		
		'SEE IF ERROR WAS "USER ALREADY EXISTS"
		If err.number = -2147019886 Then
			'DO NOTHING... REDIRECT BACK TO CALLING PAGE AND LET THAT PAGE HANDLE THE ERROR
			Exit Function
		Else		
			Call ProcessMPFError
			Exit Function
		End If
	Else
		'DEBUG CODE
		If blnMainDebug Then
			Call WriteRecord(DEBUGFILEPATH, strXMLResponse, "CreateUser-OUT")
		End If
    End If

	'GET LDAP PATH FROM RESPONSE
	objXml.LoadXML(strXMLResponse)
    Set objOrg = objXml.selectSingleNode("//*/data/user")
	CreateUser = objOrg.getAttribute("path")
    
    'Kill Ojects
    Set objOrg = Nothing
    Set objXml = Nothing

End Function

Function SubmitMPFRequest(xi_strXMLRequest, xi_strNamespace, xi_strProcedure)
	
	'INITIALIZE ERROR HANDLING
	'LET THE CALLING FUNCTION HANDLE THE ERRORS
	On Error Resume Next
	
	'DECLARE VARIABLES
    Dim objXML			'As MSXML2.DOMDocument
    Dim objNode			'As IXMLDOMNode
    Dim objXMLChild		'As IXMLDOMNode
    Dim objMPFClient	'As ProvisioningEnging.ProvisioningClient
    
    Dim strXMLResponse	'As String
    Dim strXMLText		'As String
    Dim ErrorMsgString
    'EXECUTE THE COMMAND
		
	'CLEAR ERRORS
	Err.Clear
	
	'INSTANTIATE THE MPF CLIENT OBJECT
	Set objMPFClient = CreateObject("Provisioning.ProvEngineClient")
	
		'CHECK FOR FAILURE HERE
		If Err.Number <> 0 Then
			ErrorMsgString = "We're sorry, but the Script has encountered " & _
				"an error and cannot continue.  If this problem persists, contact your " & _
				"network administrator."
				
			ErrorMsgString = ErrorMsgString & _
				"Technical details for support staff: " & _
				vbCRLF & "Error Number: " & err.number  & _
				vbCRLF & "Server Time Stamp: " & Now() 
				
			'IF THEY HAVE DEBUG TURNED ON, DISPLAY THE ENTIRE ERROR
			If vDebug = 2 Then		
				ErrorMsgString = ErrorMsgString & _
					"Full Error details:" & _
					vbCRLF & "Error Number: " & err.number  & _
					vbCRLF & "Error Description: " & err.description &  _
					vbCRLF & "Server: " & ADSystemInfo.ComputerName &  _
					vbCRLF & "Could Not instatiate MPFClient Object. Possible problems with MPF or network."
			End If
				
			Write "SubmitMPFRequest(): Unable to instantiate MPF Client"
		End If		    
	
	'LOAD THE XML OBJECT AND ADD THE USER'S CREDENTIALS TO THE REQUEST
	Set objXML = CreateObject("MSXML2.DOMDocument")
	objXML.LoadXML xi_strXMLRequest
	
	'SUBMIT THE REQUEST
	strXMLResponse = objMPFClient.SubmitRequest(objXML.xml, xi_strNamespace, xi_strProcedure)

	'CLEANUP
	Set objMPFClient = Nothing
	Set objXMLChild = Nothing
	Set objNode = Nothing
	Set objXML = Nothing
			
	'RETURN RESPONSE
	SubmitMPFRequest = strXMLResponse

End Function
' Handle an Error that has been returned
Sub ProcessMPFError()

	'DECLARE VARIABLES
	Dim intErrID
	Dim lngErrorNum
	Dim strErrorDesc
	
	'GET AND STORE ERROR INFORMATION
	lngErrorNum = err.number
	strErrorDesc = err.Description
	
	'CLEAR THE GLOBAL STRING
	ErrorMsgString = ""
	
	'WRITE THE ERROR TO THE DB AND GET THE REFERENCE NUMBER
	Write "MPF Call," & lngErrorNum & " ,Error calling MPF: " & strErrorDesc & " MigrateToCM.wsf"

	'IF THEY HAVE DEBUG TURNED ON, DISPLAY THE ENTIRE ERROR
	If vDebug = 2 Then		
		ErrorMsgString = _
			"Full Error details:" & _
			vbCRLF & "Error Number: <B>" & lngErrorNum & _
			vbCRLF & "Error Description: " & strErrorDesc & _
			vbCRLF & "Server: " & ADSystemInfo.ComputerName
	End If

	'DIRECT USER TO ERROR PAGE FOR DISPLAY
	write ErrorMsgString
	
	'CLEANUP
	Err.Clear	
End Sub
' Enable a User Account
Function EnableUser(xi_strUser)
    On Error Resume Next
    
	'DIM VARIABLES
    Dim objXml
    Dim objOrg

    Dim strXmlFile
    Dim strXMLResponse
    Dim AdsPath

    'LOAD THE XML OBJECT
    Set objXML = CreateObject("MSXML2.DOMDocument")
    
	'LOAD XML TEMPLATE    
    strXmlFile = strXMLPath & "\AD\" & "EnableUser.xml"
    objXml.Load (strXmlFile)
    
	'SET THE USER PATH
    Set objOrg = objXml.selectSingleNode("//*/data/user")
    objOrg.Text = CStr(xi_strUser)

	'SET THE PREFERRED DOMAIN CONTROLLER
    Set objOrg = objXml.selectSingleNode("//*/data/preferredDomainController")
    objOrg.Text = prefDC


	'SUBMIT THE REQUEST
	strXMLResponse = SubmitMPFRequest(objXml.Xml, "Managed Active Directory", _
							"EnableUser")
    'CHECK FOR ERROR
    If Err.number <> 0 Then
		'DEBUG CODE
		Call ProcessMPFError
		Exit Function
	Else
		'DEBUG CODE
		
    End If

    'Kill Ojects
    Set objOrg = Nothing
    Set objXml = Nothing

End Function

' Set a Password
Function SetPassword(xi_strUser, xi_strNewPwd)
    On Error Resume Next
    
	'DIM VARIABLES
    Dim objXml
    Dim objOrg

    Dim strXmlFile
    Dim strXMLResponse
    Dim AdsPath

    'LOAD THE XML OBJECT
    Set objXML = CreateObject("MSXML2.DOMDocument")
    
	'LOAD XML TEMPLATE    
    strXmlFile = strXMLpath & "\AD\" & "SetUserPassword.xml"
    objXml.Load (strXmlFile)
    
	'SET THE USER PATH
    Set objOrg = objXml.selectSingleNode("//*/data/user")
    objOrg.Text = CStr(xi_strUser)

	'SET THE NEW PASSWORD
    Set objOrg = objXml.selectSingleNode("//*/data/newPassword")
    objOrg.setAttribute "do-not-log", "1"
    objOrg.Text = xi_strNewPwd
	
	'SET THE PREFERRED DOMAIN CONTROLLER
    Set objOrg = objXml.selectSingleNode("//*/data/preferredDomainController")
    objOrg.Text = prefDC

	'SUBMIT THE REQUEST
    strXMLResponse = SubmitMPFRequest(objXml.Xml, "Managed Active Directory", _
							"SetUserPassword")

    'CHECK FOR ERROR
    If Err.number <> 0 Then
		Call WAT_ProcessMPFError
		Exit Function
	
    End If

    'Kill Ojects
    Set objOrg = Nothing
    Set objXml = Nothing

End Function

' Add an Account to a Group
Function GroupAdd(xi_strGroup, xi_strUser)
    On Error Resume Next
    
	'DIM VARIABLES
    Dim objXml
    Dim objOrg

    Dim strXmlFile
    Dim strXMLResponse
    Dim AdsPath

    'LOAD THE XML OBJECT
    Set objXML = CreateObject("MSXML2.DOMDocument")
    
	'LOAD XML TEMPLATE    
    strXmlFile = strXMLPath & "\AD\" & "GroupAdd.xml"
    objXml.Load (strXmlFile)
    
	'SET THE GROUP PATH
    Set objOrg = objXml.selectSingleNode("//*/data/group")
    objOrg.Text = CStr(xi_strGroup)

	'SET THE USER PATH
    Set objOrg = objXml.selectSingleNode("//*/data/newMember")
    objOrg.Text = CStr(xi_strUser)

	'SET THE PREFERRED DOMAIN CONTROLLER
    Set objOrg = objXml.selectSingleNode("//*/data/preferredDomainController")
    objOrg.Text = prefDC

	'SUBMIT THE REQUEST
    strXMLResponse = SubmitMPFRequest(objXml.Xml, "Managed Active Directory", _
							"GroupAdd")
    'CHECK FOR ERROR
    If Err.number <> 0 Then
		
		'CHECK FOR SPECIAL ERRORS
		If Err.number = -2147019886 Then
		
			'USER IS ALREADY MEMBER OF THE GROUP LET CALLING PAGE HANDLE THIS
			Exit Function
		Else
			'DISPLAY THE ERROR
			Call ProcessMPFError
			Exit Function
		End If
   End If

    'Kill Ojects
    Set objOrg = Nothing
    Set objXml = Nothing

End Function

' Create a Group
Function CreateGroup(xi_strGroupName, xi_strPolicy, xi_strGroupType, xi_strDescription, xi_intRolePriority, xi_strContPath)
    On Error Resume Next
    
	'DIM VARIABLES
    Dim objMapsClient
    Dim objXml
    Dim strXmlFile
    Dim strRootOU
    Dim objOrg
    Dim objChild
    Dim strXMLResponse
    Dim AdsPath
    
    err.clear
	
    'LOAD THE MAPS CLIENT AND XML OBJECT
    Set objMapsClient = CreateObject("Provisioning.ProvEngineClient")
    Set objXml = CreateObject("Microsoft.XMLDOM")
    
	'LOAD XML TEMPLATE    
    strXmlFile = strXMLPath & "\AD\" & "CreateGroup.xml"
    objXml.Load (strXmlFile)
    
	'SET THE NAME
    Set objOrg = objXml.selectSingleNode("//*/data/name")
    objOrg.Text = CStr(xi_strGroupName)

	'SET THE POLICY TYPE
    Set objOrg = objXml.selectSingleNode("//*/data/policyName")
    objOrg.Text = xi_strPolicy
	
	'SET THE CONTAINER
    Set objOrg = objXml.selectSingleNode("//*/data/container")
    'objOrg.Text = RemoveDCFromADsPATH(CStr(strRootOU))
    objOrg.Text = xi_strContPath


	'SET THE GROUP TYPE
    Set objOrg = objXml.selectSingleNode("//*/data/groupType")
    objOrg.Text = xi_strGroupType

	'SET THE DESCRIPTION
    Set objOrg = objXml.selectSingleNode("//*/data/description")
    objOrg.Text = xi_strDescription

	'SET THE PREFERRED DOMAIN CONTROLLER
    Set objOrg = objXml.selectSingleNode("//*/data/preferredDomainController")
    objOrg.Text = prefDC

	'DEBUG CODE
    strXMLResponse = objMapsClient.SubmitRequest(objXml.Xml, "Managed Active Directory", _
							"CreateGroup")

    'CHECK FOR ERROR
    If Err.number <> 0 Then
		'DEBUG CODE
		If blnMainDebug Then
			write  Err.Description &  " ,CGroup-ERR"
		End If
		Call ProcessMPFError
		Exit Function
	Else
		'DEBUG CODE
		
    End If


	'GET LDAP PATH FROM RESPONSE
	objXml.LoadXML(strXMLResponse)
    Set objOrg = objXml.selectSingleNode("//*/data/group")
	CreateGroup = objOrg.getAttribute("path")
    
    'Kill Ojects
    Set objOrg = Nothing
    Set objXml = Nothing
    Set objMapsClient = Nothing

End Function

